
#include <windows.h>

LRESULT CALLBACK WinFunc(HWND, UINT, WPARAM, LPARAM);
char szWinName[] = "MyWindow";

//static int Cnt;

static long int T = GetTickCount ();

int WINAPI WinMain (HINSTANCE hThisInst, HINSTANCE hPrevInst, LPSTR lpszArgs, int nWinMode)
{
	MSG msg;
	WNDCLASSEX wcl;
	HWND hWnd;

	ZeroMemory (&wcl, sizeof (wcl));
	wcl.cbSize = sizeof (wcl);
	wcl.hInstance = hThisInst;
	wcl.lpszClassName = szWinName;
	wcl.lpfnWndProc = WinFunc;
	wcl.hIcon=LoadIcon (NULL, IDI_APPLICATION);
	wcl.hCursor=LoadCursor (NULL, IDC_ARROW);
	wcl.hbrBackground = (HBRUSH)(GetStockObject (WHITE_BRUSH));

	if (!RegisterClassEx (&wcl))
		return 0;

	hWnd = CreateWindow (szWinName, "Framework for Windows",
			WS_OVERLAPPEDWINDOW,
			10, 10, 480, 320,
			HWND_DESKTOP, NULL, hThisInst, NULL);

	ShowWindow (hWnd, nWinMode);
	UpdateWindow (hWnd);

	while (TRUE) {
		long int t;
//		Cnt++;
		if ( PeekMessage (&msg, NULL, 0, 0, PM_REMOVE) ) {
			if ( msg.message == WM_QUIT )
				break;
			TranslateMessage (&msg);
			DispatchMessage (&msg);
		}
		else {
//			static int long T = GetTickCount ();
//			long int t = GetTickCount ();
//			if ( t - T < 100 ) {
//				T = t;
//			}
//			else {
//				exit (1);
//			}
			Sleep (0);
		}

		t = GetTickCount ();
		if (t-T < 10000)
			T = t;
		else
			exit (1);
	}

	return msg.wParam;
}

LRESULT CALLBACK WinFunc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) {
		case WM_CLOSE:
		{
			int res = MessageBox (hwnd, "EXIT", "Are You Shure?", MB_YESNO);
			T = GetTickCount ();
			if ( res == IDYES ) {
				return DefWindowProc (hwnd, message, wParam, lParam);
			}
			break;
		}
		case WM_DESTROY:
			PostQuitMessage (0);
			break;
		default:
			return DefWindowProc (hwnd, message, wParam, lParam);
	}
	return 0;
}
